Readme for AB Circle CCID Smart Card Reader Driver.
===================================================

This package provides the source code for the AB Circle USB CCID (Chip/Smart
Card Interface Devices) and ICCD (Integrated Circuit(s) Card Devices)
driver. See the USB CCID [1] and ICCD [2] specifications from the USB
working group.

abcccid is based on ccid. See CCID free software driver [3] for more
information.

To build abcccid, you need the following software:

Linux
- Build essentials (package build-essential)
- pcsclite 1.8.3 or above (package libpcsclite-dev)
- libusb 1.0.9 or above (package libusb-1.0.0-dev)
- flex
- perl
- pkg-config

Mac OS X
- libusb 1.0.9 or above
- pkg-config

For more information, see also the INSTALL file.

[1] http://www.usb.org/developers/docs/devclass_docs/DWG_Smart-Card_CCID_Rev110.pdf  
[2] http://www.usb.org/developers/docs/devclass_docs/DWG_Smart-Card_USB-ICC_ICCD_rev10.pdf  
[3] https://ccid.apdu.fr/  

Supported operating systems:
============================

- GNU/Linux (libusb 1.0)
- MacOS X/Darwin (libusb 1.0)

Debug information:
==================

The driver uses the debug function provided by pcscd. So if pcscd sends
its debug to stdout (`pcscd --foreground`) then the CCID driver will also
send its debug to stdout. If pcscd sends its debug to syslog (by
default) then the CCID driver will also send its debug to syslog.

You can change the debug level using the `Info.plist` configuration file.
The `Info.plist` is installed, by default, in
`/usr/local/pcsc/drivers/ifd-ccid.bundle/Contents/Info.plist`
or set the environment variable `LIBCCID_ifdLogLevel`.

The debug level is set in the `ifdLogLevel` field. It is a binary OR
combination of 4 different levels.
- 1: critical: important error messages
- 2: info:     informative messages like what reader was detected
- 4: comm:     a dump of all the bytes exchanged between the host and the
               reader
- 8: periodic: periodic info when pcscd test if a card is present (every
               1/10 of a second)

By default the debug level is set to 3 (1 + 2) and correspond to the
critical and info levels.

You have to restart the driver so it reads the configuration file again
and use the new debug level value.  To restart the driver you just need
to unplug all your CCID readers so the driver is unloaded and then replug
your readers. You can also restart pcscd.


Voltage selection
=================

You can change the voltage level using the `Info.plist` configuration
file.  The `Info.plist` is installed, by default, in
`/usr/local/pcsc/drivers/ifd-ccid.bundle/Contents/Info.plist`

The voltage level is set in the `ifdDriverOptions` field. It is a binary OR
combination of 4 different levels.

-  0: power on the card at 5V (default value)
- 16: power on the card at 3V and, if 3V fails then use 5V
- 32: power on the card at 1.8V, then 3V and then 5V
- 48: let the reader decide

By default the voltage level is set to 0 and corresponds to 5V.

You have to restart the driver so it reads the configuration file again
and uses the new debug level value.  To restart the driver you just need
to unplug all your CCID readers so the driver is unloaded and then replug
your readers.  You can also restart pcscd.


Licence:
========

  This library is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at
your option) any later version.

  This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


History:
========

2.2.2                           23 July 2025
--------------------------------------------
- Added support for additional custom reader

2.2.1                       13 February 2025
--------------------------------------------
- Added support for additional custom reader

2.2.0                        13 January 2025
--------------------------------------------
- Added support for custom readers

2.1.9                        17 October 2024
--------------------------------------------
- Added support for Circle CIR115 CT reader
- Added support for Circle CIR315-SE CL reader

2.1.8                       05 February 2024
--------------------------------------------
- Added support for Circle CIR135 reader

2.1.7                            02 May 2023
--------------------------------------------
- Updated version to 2.1.7

2.1.6                          24 April 2023
--------------------------------------------
- Removed unused readers

2.1.5                       23 February 2023
--------------------------------------------
- Use default read timeout to 3 seconds (except apdu) to prevent macOS waiting 
  to unload driver for a long time after reader suprise removal
- Stop read / polling threads after 5 times an error occurs (to stop threads 
  racing after reader suprise removal)
- Added minor fixes from latest generic ccid package 1.5.2 
  from Ludovic Rousseau (https://ccid.apdu.fr/)

2.1.4                      16 September 2022
--------------------------------------------
- Merged changes from the latest generic ccid package 1.5.0 from Ludovic Rousseau
  (https://ccid.apdu.fr/):
    - Add support of simultaneous slot access on multi slots readers
    - always compute readTimeout to use a value greater than default 3 seconds
    - Check the bSeq value when receiving a CCID frame
    - Avoid logging errors when a reader is removed
    - Some other minor improvements
    - By default hide buffer info in CCID frames

2.1.3                           06 July 2022
--------------------------------------------
- Enabled extended apdu support for CIR315B reader
- Added support for Circle CIR715 reader
- Added support for custom readers

2.1.2                         18 August 2021
--------------------------------------------
- Added support for custom readers

2.1.1                           29 June 2021
--------------------------------------------
- Added support for Circle CIR125 ICC reader

2.1.0                           02 June 2021
--------------------------------------------
- Added support for custom readers

2.0.9                            10 May 2021
--------------------------------------------
- Added support for Circle CIR515 ICC reader

2.0.8                            07 May 2021
--------------------------------------------
- Special (32-slot) edition for CSR105 reader

2.0.7                          29 March 2021
--------------------------------------------
- Added support for custom reader
- Improved support for composite devices on macOS Big Sur

2.0.6                          10 March 2021
--------------------------------------------
- Added support for custom readers
- Small change in Info.plist

2.0.5                       03 December 2020
--------------------------------------------
- Added support for:
    ⁃ Circle CIR315 IMP
    ⁃ Circle CIR415 CL
    ⁃ Circle CIR615 CL & 1S
    ⁃ Circle CIR615 CL	
   Readers.
- Added support for Apple M1 architecture (Mac OSX Installer only)
- Fixed detection issue with composite device readers in Mac OS  
- Fixed minor issue in CIR415 SAM slot handling

2.0.4                        09 October 2020
--------------------------------------------
- Re-compiled with proper libusb versions (Mac OSX only)

2.0.3                      02 September 2020
--------------------------------------------
- Initialise default read timeout on card power up
- Made default read timeout longer (as it was too short for some cases).

2.0.2                            28 May 2020
--------------------------------------------
- Improved behaviour of ifsc and ifsd setting for T=1 protocol
- Don't send SetParameters for card using default speed.
- Fixed issue in T=1 IFS max frame length setting.

2.0.1                       03 February 2020
--------------------------------------------
- Added support for Escape Command IO Control Code 3500.

2.0.0                        15 October 2019
--------------------------------------------
- Removed PPS call for all ABC readers (use CCID_SetParameters only).
- Implemented new reader names.

1.0.1                      04 September 2019
--------------------------------------------
- Always start multi-slot card detection thread as on MacOS X Mojave pcscd is 
  not used anymore (thus treat all readers as multi-slot). 
- Merged changes from the latest generic ccid package 1.4.3x from Ludovic Rousseau
  (https://ccid.apdu.fr/)

1.0.0                         16 August 2019
--------------------------------------------
- Initial release
- Based on the generic ccid package 1.4.30 from Ludovic Rousseau (https://ccid.apdu.fr/)
- Added support for:
    - Circle CIR115 ICC
    - Circle CIR215 PICC
    - Circle CIR215 CL
    - Circle CIR315 Dual & 1S
    - Circle CIR315 PICC
    - Circle CIR315 SAM
    - Circle CIR315 CL
    - Circle CIR315 DI
    - Circle CIR415 CL & 1S
    Readers.
- Fixed issue of TPDU pps being sent to APDU reader.
