Readme for AB Circle CCID Smart Card Reader Driver
==================================================

This library provides a PC/SC IFD handler implementation for the AB Circle 
USB smart card readers compliant to the CCID protocol. This package will 
enable communications with all ABC CCID smartcard readers through the 
PC/SC Lite resource manager (pcscd). 

To install abcccid, either:
- Open the .deb file using a Software Manager or Package Installer and 
  follow the instructions.
- Open a terminal window and typing "dpkg -i <driver-package>.deb"

Note:
In order for PC/SC to be used, the PC/SC Lite resource manager (pcscd)
should be installed as well. This can be done through a terminal window
and typing "sudo apt install pcscd".

Supported operating systems:
============================

- Linux Debian 11 (bullseye)
- Linux Debian 10 (buster)
- Linux Debian 9 (stretch)
- Linux Ubuntu 20.04 (Focal Fossa)
- Linux Ubuntu 19.10 (Eoan Ermine)
- Linux Ubuntu 19.04 (Disco Dingo)
- Linux Ubuntu 18.04 (Bionic Beaver)
- Linux Ubuntu 16.04 (Xenial Xerus)
- Linux Ubuntu 14.04 (Trusty Tahr)
- Linux Mint 19.1 (Tessa)

Note: 
Older Debian releases or additional Debian-based OSes should work as well, 
but are un-tested at this time.

Licence:
========

  This library is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at
your option) any later version.

  This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


History:
========

2.2.2                           25 July 2025
--------------------------------------------
- Added support for custom reader

2.2.1                       18 February 2025
--------------------------------------------
- Added support for custom reader

2.2.0                        21 January 2025
--------------------------------------------
- Added support for custom readers

2.1.9                        23 October 2024
--------------------------------------------
- Added support for Circle CIR115 CT reader
- Added support for Circle CIR315-SE CL reader

2.1.8                          12 March 2024
--------------------------------------------
- Added support for Circle CIR135 reader

2.1.7                            04 May 2023
--------------------------------------------
- Updated version to 2.1.7

2.1.6                          27 April 2023
--------------------------------------------
- Removed unused readers

2.1.5                       23 February 2023
--------------------------------------------
- Use default read timeout to 3 seconds (except apdu) to prevent macOS waiting 
  to unload driver for a long time after reader suprise removal
- Stop read / polling threads after 5 times an error occurs (to stop threads 
  racing after reader suprise removal)
- Added minor fixes from latest generic ccid package 1.5.2 
  from Ludovic Rousseau (https://ccid.apdu.fr/)

2.1.4                      20 September 2022
--------------------------------------------

- Merged changes from the latest generic ccid package 1.5.0 from Ludovic Rousseau (https://ccid.apdu.fr/):
    - Add support of simultaneous slot access on multi slots readers
    - Always compute readTimeout to use a value greater than default 3 seconds
    - Check the bSeq value when receiving a CCID frame
    - Avoid logging errors when a reader is removed
    - Some other minor improvements
    - By default hide buffer info in CCID frames

2.1.3                         23 August 2022
--------------------------------------------
- Enabled extended apdu support for CIR315B reader
- Added support for Circle CIR715 reader
- Added support for custom readers

2.1.2                        14 January 2022
--------------------------------------------
- Added support for custom readers

2.1.1                           29 June 2021
--------------------------------------------
- Added support for Circle CIR125 ICC reader

2.1.0                           18 June 2021
--------------------------------------------
- Added support for custom reader

2.0.9                            10 May 2021
--------------------------------------------
- Added support for:
    - Circle CIR515 ICC reader
    - Custom reader

2.0.8                            07 May 2021
--------------------------------------------
- Special (32-slot) edition for CSR105 reader

2.0.7                          13 April 2021
--------------------------------------------
- Added support for custom reader
- Improved support for composite devices on macOS Big Sur

2.0.6                          12 March 2021
--------------------------------------------
- Added support for custom readers
- Small change in Info.plist

2.0.5                       03 December 2020
--------------------------------------------
- Added support for:
	⁃	Circle CIR315 IMP
	⁃	Circle CIR415 CL
	⁃	Circle CIR615 CL & 1S
	⁃	Circle CIR615 CL	
		Readers.
- Fixed detection issue with composite device readers in Mac OS  
- Fixed minor issue in CIR415 SAM slot handling

2.0.4                        09 October 2020
--------------------------------------------
- Re-compiled with proper libusb versions (Mac OSX only)

2.0.3                      02 September 2020
--------------------------------------------
- Initialise default read timeout on card power up
- Made default read timeout longer (as it was too short for some cases)

2.0.2                            28 May 2020
--------------------------------------------
-    Improved behaviour of ifsc and ifsd setting for T=1 protocol
-    Don't send SetParameters for card using default speed.
-    Fixed issue in T=1 IFS max frame length setting.

2.0.1                       03 February 2020
--------------------------------------------
-    Added support for Escape Command IO Control Code 3500.

2.0.0                        15 October 2019
--------------------------------------------
-    Removed PPS call for all ABC readers (use CCID_SetParameters only).
-    Implemented new reader names.

1.0.1                      04 September 2019
--------------------------------------------
-    Always start multi-slot card detection thread as on MacOS X Mojave pcscd is 
     not used anymore (thus treat all readers as multi-slot).  
-    Merged changes from the latest generic ccid package 1.4.3x from Ludovic Rousseau
     (https://ccid.apdu.fr/)  

1.0.0                         16 August 2019
--------------------------------------------
-    Initial release  
-    Based on the generic ccid package 1.4.30 from Ludovic Rousseau (https://ccid.apdu.fr/)  
-    Added support for:  
     -    Circle CIR115 ICC  
     -    Circle CIR215 PICC  
     -    Circle CIR215 CL  
     -    Circle CIR315 Dual & 1S  
     -    Circle CIR315 PICC  
     -    Circle CIR315 SAM  
     -    Circle CIR315 CL  
     -    Circle CIR315 DI  
     -    Circle CIR415 CL & 1S  
     Readers.  
-    Fixed issue of TPDU pps being sent to APDU reader.

===================================================
(c) 2019-2025 AB Circle Limited